// === Elements ===
const themeToggle = document.getElementById('themeToggle');
const beep = document.getElementById('beepSound');

// ---- Theme Toggle ----
themeToggle.addEventListener('click', () => {
  document.documentElement.classList.toggle('dark');
  themeToggle.textContent = document.documentElement.classList.contains('dark') ? '🌙' : '☀️';
});

// ---- Utility Functions ----
const formatTime = (t) => `${String(Math.floor(t/60)).padStart(2,'0')}:${String(t%60).padStart(2,'0')}`;
const formatMs = (ms) => {
  const s = Math.floor(ms/1000);
  const cs = Math.floor((ms%1000)/10);
  return `${String(Math.floor(s/60)).padStart(2,'0')}:${String(s%60).padStart(2,'0')}.${String(cs).padStart(2,'0')}`;
};

// === 1️⃣ Interval Timer ===
let intervalState = { running:false, time:10, total:10, timer:null };
const intervalTime = document.getElementById('intervalTime');
const intervalProgress = document.getElementById('intervalProgress');
const intervalStatus = document.getElementById('intervalStatus');

document.getElementById('intervalStart').onclick = () => {
  if (intervalState.running) return;
  intervalState.running = true;
  intervalStatus.textContent = "Running...";
  intervalState.timer = setInterval(()=>{
    if (intervalState.time>0) {
      intervalState.time--;
      const percent = ((intervalState.total-intervalState.time)/intervalState.total)*100;
      intervalProgress.style.width = percent+"%";
      intervalTime.textContent = formatTime(intervalState.time);
    } else {
      clearInterval(intervalState.timer);
      intervalState.running = false;
      beep.play();
      if (navigator.vibrate) navigator.vibrate([200,100,200]);
      intervalStatus.textContent = "Done!";
    }
  },1000);
};
document.getElementById('intervalPause').onclick = ()=>{
  clearInterval(intervalState.timer);
  intervalState.running=false;
  intervalStatus.textContent="Paused";
};
document.getElementById('intervalReset').onclick=()=>{
  clearInterval(intervalState.timer);
  intervalState={running:false,time:10,total:10,timer:null};
  intervalTime.textContent="00:10";
  intervalProgress.style.width="0%";
  intervalStatus.textContent="Ready";
};

// === 2️⃣ Stopwatch ===
let sw={start:0,elapsed:0,running:false,timer:null,laps:[]};
const swTime=document.getElementById('stopwatchTime');
const swStatus=document.getElementById('stopwatchStatus');
const swLapList=document.getElementById('lapList');

document.getElementById('stopwatchStartStop').onclick=()=>{
  if(sw.running){ // pause
    clearInterval(sw.timer);
    sw.running=false;
    swStatus.textContent="Paused";
  } else {
    sw.running=true;
    sw.start=Date.now()-sw.elapsed;
    sw.timer=setInterval(()=>{
      sw.elapsed=Date.now()-sw.start;
      swTime.textContent=formatMs(sw.elapsed);
    },50);
    swStatus.textContent="Running...";
  }
};
document.getElementById('stopwatchLap').onclick=()=>{
  if(!sw.running)return;
  sw.laps.unshift(sw.elapsed);
  renderLaps();
};
document.getElementById('stopwatchReset').onclick=()=>{
  clearInterval(sw.timer);
  sw={start:0,elapsed:0,running:false,timer:null,laps:[]};
  swTime.textContent="00:00.00";
  swStatus.textContent="Ready";
  renderLaps();
};
function renderLaps(){
  swLapList.innerHTML=sw.laps.map((t,i)=>`<div><span>Lap ${sw.laps.length-i}</span><span>${formatMs(t)}</span></div>`).join('');
}

// === 3️⃣ Countdown Timer ===
let cd={running:false,time:300,total:300,timer:null};
const cdTime=document.getElementById('countdownTime');
const cdProgress=document.getElementById('countdownProgress');

function updateCountdownDisplay(){
  cdTime.textContent=formatTime(cd.time);
  const percent=((cd.total-cd.time)/cd.total)*100;
  cdProgress.style.width=percent+"%";
}

document.getElementById('countdownStartStop').onclick=()=>{
  if(cd.running){
    clearInterval(cd.timer);
    cd.running=false;
  }else{
    const min=parseInt(document.getElementById('countdownMin').value)||0;
    const sec=parseInt(document.getElementById('countdownSec').value)||0;
    cd.total=min*60+sec;
    cd.time=cd.total;
    cd.running=true;
    cd.timer=setInterval(()=>{
      if(cd.time>0){
        cd.time--;
        updateCountdownDisplay();
      }else{
        clearInterval(cd.timer);
        cd.running=false;
        beep.play();
        if(navigator.vibrate) navigator.vibrate(300);
      }
    },1000);
  }
};
document.getElementById('countdownReset').onclick=()=>{
  clearInterval(cd.timer);
  cd.running=false;
  cd.time=cd.total;
  updateCountdownDisplay();
};

updateCountdownDisplay();
